/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure fConnection;
    private ConnectionFigure fPrototype;
    private Figure fTarget = null;

    public ConnectionHandle(Figure owner, Locator l, ConnectionFigure prototype) {
        super(owner, l);
        this.fPrototype = prototype;
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect() && !target.includes(this.owner()) && this.fConnection.canConnect(this.owner(), target)) {
            return this.findConnector(x, y, target);
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target != null) {
            this.fConnection.connectStart(this.startConnector());
            this.fConnection.connectEnd(target);
            this.fConnection.updateConnection();
        } else {
            view.drawing().remove(this.fConnection);
        }
        this.fConnection = null;
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.fConnection = this.createConnection();
        Point p = this.locate();
        this.fConnection.startPoint(p.x, p.y);
        this.fConnection.endPoint(p.x, p.y);
        view.drawing().add(this.fConnection);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = this.findConnectableFigure(x, y, view.drawing());
        if (f != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = f;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        }
        this.fConnection.endPoint(p.x, p.y);
    }

    private Connector startConnector() {
        Point p = this.locate();
        return this.owner().connectorAt(p.x, p.y);
    }
}

